public static class NSCCOMHelper
{
    public static int mApplicationPort;
    public static int mDefaultPort;

    public enum PacketType
    {
        None = 0,
        Data = 1,
        Ctrl = 2,
        Echo = 4,
        TimeGet = 5,
        TimeSet = 6,
        DataEven = 7
    }

    public enum BitPerSeconds
    {
        Bps9600 = 9600,
        Bps14400 = 14400,
        Bps19200 = 19200,
        Bps38400 = 38400,
        Bps57600 = 57600
    }

    public enum AdapterID
    {
        Simple = 0,
        Fast = 1
    }

    public enum PacketMode
    {
        Connected = 0,
        Datagram = 1,
        Stream = 2
    }

    public enum OpCodes
    {
        Echo = 0,
        CtrlPacket = 1,
        DataPacket = 2,
        TimeSet = 3,
        TimeGet = 4,
        System = 6
    }

    public enum SendResult
    {
        Failed = 0,
        Ok = 1,
        Busy = 2,
        DeviceClosed = 16,
        BadCall = 99
    }
}


public enum CtrlTypes
{
    SetTarget = 1,
    SetOut = 2,
    DumpErr = 5,
    GetIn = 6,
    GetOut = 7,
    User = 43,
    UserDatagram = 141,
    LongClickState = 246,
    ClickState = 247,
    InState = 248,
    OutState = 249
}

public enum RespMsgs
{
    DisableResponse = 0,
    CtrlTypeOk = 242
}

public enum Proto
{
    SFBP1 = 1,
    SFBP2 = 2
}

public enum ProgramErrors
{
    None = 0,
    BadCall = 1,
    ComClosed = 2,
    NetworkFailure = 3,
    NoResponse = 4,
    SerialMismatch = 5 // Assuming based on naming
}


public partial class frmSFBP232Settings : Form
{
    public frmSFBP232Settings()
    {
        InitializeComponent();
    }

	private void cmdSaveSettings_Click(object sender, EventArgs e)
	{
		bool wasOpen = false;

		if (NSCCOMHelper.IsOpen())
		{
			wasOpen = true;
			NSCCOMHelper.CloseCOM();
		}

		NSCCOMHelper.SetAdapterID((int)cmbAdapter.SelectedValue);
		NSCCOMHelper.SetBps((int)cmbBaud.SelectedValue);
		NSCCOMHelper.SetFrameSize(int.Parse(cmbFramesize.SelectedItem.ToString()));
		NSCCOMHelper.SetLocalAddress(int.Parse(txtLocalAddr.Text));
		NSCCOMHelper.SetCOMPort(cmbPort.SelectedIndex + 1);
		NSCCOMHelper.mDefaultPort = cmbPort.SelectedIndex + 1;
		NSCCOMHelper.mApplicationPort = cmbAppPort.SelectedIndex;

		NSCCOMHelper.SetPacketTimeout(int.Parse(txtTimeout.Text));
		NSCCOMHelper.SetBusyTimeout(int.Parse(txtBTimeout.Text));

		NSCCOMHelper.SaveSFBPdriverSettings();

		if (wasOpen)
			NSCCOMHelper.OpenCOM();

		this.Close(); // Equivalent to VB6's "Unload Me"
	}

	private void Form1_Load(object sender, EventArgs e)
	{
		lblVers.Text = "SM SFBP 232 COM driver version:\r\n" + NSCCOMHelper.GetSFBPDrvVers();

		// --- Adapter ComboBox ---
		cmbAdapter.Items.Add(new ComboBoxItem("SIMPLE", (int)NSCCOMHelper.AdapterID.Simple));
		cmbAdapter.Items.Add(new ComboBoxItem("FAST", (int)NSCCOMHelper.AdapterID.Fast));

		for (int i = 0; i < cmbAdapter.Items.Count; i++)
		{
			if ((int)((ComboBoxItem)cmbAdapter.Items[i]).Value == NSCCOMHelper.getAdapterID())
			{
				cmbAdapter.SelectedIndex = i;
				break;
			}
		}

		// --- Port ComboBox ---
		int z = NSCCOMHelper.mDefaultPort > 0 ? NSCCOMHelper.mDefaultPort : NSCCOMHelper.GetCOMPort();
		for (int i = 0; i < 32; i++)
		{
			cmbPort.Items.Add((i + 1).ToString());
			if (i + 1 == z) cmbPort.SelectedIndex = i;
		}

		// --- Application Port ComboBox ---
		for (int i = 0; i <= 32; i++)
		{
			cmbAppPort.Items.Add(i == 0 ? "*use default*" : i.ToString());
			if (i == NSCCOMHelper.mApplicationPort) cmbAppPort.SelectedIndex = i;
		}

		// --- Baud Rate ComboBox ---
		AddBaudRate("9600", (int)NSCCOMHelper.BitPerSeconds.Bps9600);
		AddBaudRate("14400", (int)NSCCOMHelper.BitPerSeconds.Bps14400);
		AddBaudRate("19200", (int)NSCCOMHelper.BitPerSeconds.Bps19200);
		AddBaudRate("38400", (int)NSCCOMHelper.BitPerSeconds.Bps38400);
		AddBaudRate("57600", (int)NSCCOMHelper.BitPerSeconds.Bps57600);

		for (int i = 0; i < cmbBaud.Items.Count; i++)
		{
			if ((int)((ComboBoxItem)cmbBaud.Items[i]).Value == NSCCOMHelper.GetBps())
			{
				cmbBaud.SelectedIndex = i;
				break;
			}
		}

		txtLocalAddr.Text = NSCCOMHelper.getLocalAddress().ToString();

		// --- Frame Size ComboBox ---
		cmbFramesize.Items.Add("7");
		cmbFramesize.Items.Add("8");

		for (int i = 0; i < cmbFramesize.Items.Count; i++)
		{
			if (int.Parse(cmbFramesize.Items[i].ToString()) == NSCCOMHelper.GetFrameSize())
			{
				cmbFramesize.SelectedIndex = i;
				break;
			}
		}

		txtTimeout.Text = NSCCOMHelper.getPacketTimeout().ToString();
		txtBTimeout.Text = NSCCOMHelper.getBusyTimeout().ToString();
	}

	public class ComboBoxItem
	{
		public string Text { get; }
		public object Value { get; }

		public ComboBoxItem(string text, object value)
		{
			Text = text;
			Value = value;
		}

		public override string ToString() => Text;
	}

	private void AddBaudRate(string label, int value)
	{
		cmbBaud.Items.Add(new ComboBoxItem(label, value));
	}


	/*
	 Usage Example:

	private void txtLocalAddr_Leave(object sender, EventArgs e)
	{
		CheckTextBoxRange(txtLocalAddr, 1, 255);
	}

	*/
	private void CheckTextBoxRange(TextBox txt, long min, long max)
	{
		if (string.IsNullOrWhiteSpace(txt.Text))
			return;

		int cursorPosition = txt.SelectionStart;

		// Remove all non-digit characters
		string cleaned = new string(txt.Text.Where(char.IsDigit).ToArray());

		// Restore cursor within new bounds
		txt.Text = cleaned;
		txt.SelectionStart = Math.Min(cursorPosition, cleaned.Length);

		// Clamp to min/max if not empty
		if (long.TryParse(txt.Text, out long value))
		{
			if (value < min)
				txt.Text = min.ToString();
			else if (value > max)
				txt.Text = max.ToString();
		}
	}

	private void txtTimeout_TextChanged(object sender, EventArgs e)
	{
		CheckTextBoxRange(txtTimeout, 0, 32767);
	}

	private void txtBTimeout_TextChanged(object sender, EventArgs e)
	{
		CheckTextBoxRange(txtBTimeout, 0, 32767);
	}

	private void txtLocalAddr_TextChanged(object sender, EventArgs e)
	{
		CheckTextBoxRange(txtLocalAddr, 1, 127);
	}

	/*
	Don’t forget:

	  In the designer (.Designer.cs) or using the Properties panel in Visual Studio, hook up each event:

	this.txtTimeout.TextChanged += new System.EventHandler(this.txtTimeout_TextChanged);

	*/
	
}

